/*
	webfilt 0.96 - CGI component
	Copyright (C) 2004, Jem E. Berkes <jberkes@pc-tools.net>
	http://www.pc-tools.net/unix/webfilt/
	
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "config.h"
#include "webfilt.h"

void deadexit();
void new_login();
void re_login(int);
void listing();
void list_email(struct email*);
void show_prompt();
void show_file();
void exec_command();
void show_error(const char*);
void html_sanitize(char*, char*);


int content_set = 0;
FILE* remote = NULL;
char* script_name = NULL;
char* server_name = NULL;
char username[BUFSIZE] = "";	/* UNIX user name */
char password[BUFSIZE] = "";	/* UNIX password */
char secret[BUFSIZE] = "";	/* sessional random secret */
char folder[BUFSIZE] = "";	/* either spam or good */
int foldercode = 0;
char filenames[BUFSIZE] = "";	/* file names to perform ac*/
char command[BUFSIZE] = "";	/* command to invoke, user-defined */
char showfile[BUFSIZE] = "";	/* file name to show */

int main()
{
	int job, sock;
	struct sockaddr_in sin;
	char postbuf[BUFSIZE];		/* must be long enough to hold POST request */
	char* argtok;

	script_name = getenv("SCRIPT_NAME");
	if (!script_name)
		script_name = "/cgi-bin/webfilt.cgi";
	server_name = getenv("SERVER_NAME");
	if (!server_name)
		server_name = "localhost";

	if (!fgets(postbuf, sizeof(postbuf), stdin))
	{
		show_prompt();
		return RETCODE_OK;
	}
	argtok = strtok(postbuf, "&");
	while (argtok)
	{
		char temp_file[BUFSIZE];
		char* latter = strstr(argtok, "=view");
		sscanf(argtok, "user=%s", username);
		sscanf(argtok, "password=%s", password);
		if (sscanf(argtok, "folder=%s", folder) == 1)
			foldercode = (strcasecmp(folder, "spam") == 0);
		sscanf(argtok, "secret=%s", secret);
		if (sscanf(argtok, "filename=%s", temp_file) == 1)
		{
			strcat(filenames, temp_file);
			strcat(filenames, ";");
		}
		sscanf(argtok, "command=%s", command);
		if (latter)	/* special case of reverse name/value pair */
		{
			*latter = '\0';
			strcpy(showfile, argtok);
		}
		argtok = strtok(NULL, "&");
	}
	
	/* Try to connect to webfiltd */
	sin.sin_family = AF_INET;
	sin.sin_port = htons(WEBFILTD_PORT);
	if (inet_aton(WEBFILTD_IP, &sin.sin_addr) == 0)
	{
		show_error("Improper IP for webfiltd");
		return RETCODE_FAIL;
	}

	/* Based on available variables, we can determine type of CGI invocation */
	if (*username && *secret && *folder && *command)
		job = DO_EXECUTE;
	else if (*username && *secret && *folder && *showfile)
		job = DO_SHOWFILE;
	else if (*username && *secret && *folder)
		job = DO_RELOGIN;
	else if (*username && *password && *folder)
		job = DO_NEWLOGIN;
	else
	{
		show_prompt();
		return RETCODE_OK;
	}
		
	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock == -1)
	{
		show_error("Unable to get socket");
		return RETCODE_FAIL;
	}
	if (connect(sock, (struct sockaddr*)&sin, sizeof(sin)) != 0)
	{
		close(sock);
		show_error("Unable to connect to webfiltd (local backend)");
		return RETCODE_FAIL;
	}
	remote = fdopen(sock, "r+");
	if (!remote)
	{
		close(sock);
		show_error("Unable to initiate socket stream to webfiltd");
		return RETCODE_FAIL;
	}
	/* We now have a FILE* remote, connected to webfiltd over a socket */
	
	switch (job)
	{
		case DO_NEWLOGIN:
			new_login();
			break;

		case DO_RELOGIN:
			re_login(DO_RELOGIN);
			break;
			
		case DO_SHOWFILE:
			re_login(DO_SHOWFILE);
			break;
			
		case DO_EXECUTE:
			re_login(DO_EXECUTE);
			break;
	}

	fprintf(remote, "QUIT\n");		
	fclose(remote);
	return 0;
}


void deadexit()
{
	show_error("[ Connection to webfiltd (local backend) died unexpectedly ]");
	exit(RETCODE_FAIL);
}



void new_login()
{
	char linebuf[BUFSIZE];
	/* Send login request */
	if (fprintf(remote, "LOGIN %s %s %d\n", username, password, foldercode) < 1)
		deadexit();

	/* Read response */
	if (!fgets(linebuf, sizeof(linebuf), remote))
		deadexit();
	if (sscanf(linebuf, "+%s", secret) == 1)
		listing();
	else
		show_error("Login failed");
}



/*
	After doing RELOGIN, a number of things may be done next
	DO_EXECUTE
	DO_SHOWFILE
	DO_RELOGIN (default, show listing)

*/
void re_login(int next)
{
	char linebuf[BUFSIZE];
	/* Send re-login request to continue active session */
	if (fprintf(remote, "RELOGIN %s %s %d\n", username, secret, foldercode) < 1)
		deadexit();
		
	/* Read response */
	if (!fgets(linebuf, sizeof(linebuf), remote))
		deadexit();
	if (*linebuf == '+')
	{
		if (next == DO_EXECUTE)
		{
			if (*filenames)
				exec_command();
			else
				show_error("No files were selected for command");
		}
		else if (next == DO_SHOWFILE)
			show_file();
		else
			listing();
	}
	else
	{
		printf("Content-Type: text/html\n\n");
		content_set = 1;
		printf("<p align=\"center\"><b>Invalid session (sessions expire after %d seconds)</b><br>", SESSION_LEN);
		printf("<a href=\"%s\">[back]</a></p>", script_name);
	}
}


void listing()
{
	struct email *messages, *current;
	char linebuf[BUFSIZE], parsed[BUFSIZE];
	if (fprintf(remote, "LIST\n") < 1)
		deadexit();
	
	printf("Content-Type: text/html\n\n");
	content_set = 1;
	puts("<html>");
	puts("<head>");
	printf("<title>%s's %s folder</title>\n", username, folder);
	puts("</head>");
	puts("<body>");
	printf("<h2>%s's %s folder</h2>\n", username, folder);
	printf("<form action=\"%s\" method=\"POST\">\n", script_name);
	printf("<input type=\"hidden\" name=\"user\" value=\"%s\">\n", username);
	printf("<input type=\"hidden\" name=\"secret\" value=\"%s\">\n", secret);
	puts("Go to folder: ");
	puts("<input type=\"submit\" name=\"folder\" value=\"spam\">&nbsp;&nbsp;");
	puts("<input type=\"submit\" name=\"folder\" value=\"good\"> -");
	printf("<a href=\"%s\">[exit]</a>\n", script_name);
	puts("</form>");
	printf("<form action=\"%s\" method=\"POST\" target=\"_blank\">\n", script_name);
	printf("<input type=\"hidden\" name=\"user\" value=\"%s\">\n", username);
	printf("<input type=\"hidden\" name=\"secret\" value=\"%s\">\n", secret);
	printf("<input type=\"hidden\" name=\"folder\" value=\"%s\">\n", folder);
	puts("<table border=\"2\" width=\"100%\">");
	puts("<tr bgcolor=\"#eeeeee\">");
	puts("<td>&nbsp;</td><th>Subject</th><th>From</th><th>Time</th><th>Source</th>");
	puts("</tr>");
	
	/* Iterate for each file listed by webfiltd */
	messages = malloc(sizeof(struct email));
	memset(messages, 0, sizeof(struct email));
	current = messages;
	if (!fgets(linebuf, sizeof(linebuf), remote))
		deadexit();
	while ((*linebuf != '+') && (sscanf(linebuf, "%s", parsed) == 1))
	{
		current->next = malloc(sizeof(struct email));
		current = current->next;
		memset(current, 0, sizeof(struct email));
		strcpy(current->filename, parsed);
		if (!fgets(linebuf, sizeof(linebuf), remote))
			deadexit(); 
	}
	/* Created dynamic structure for all emails, fill in details */
	for (current=messages->next; current; current=current->next)
		list_email(current);
	puts("</table><br>");
	
	if (fprintf(remote, "LISTEXEC\n") < 1)	
		deadexit();
	if (!fgets(linebuf, sizeof(linebuf), remote))
		deadexit();
	while ((*linebuf != '+') && (sscanf(linebuf, "%s", parsed) == 1))
	{
		printf("<input type=\"submit\" name=\"command\" value=\"%s\">&nbsp;&nbsp;", parsed);
		if (!fgets(linebuf, sizeof(linebuf), remote))
			deadexit();
	}
	puts("<br>-<br>");
	puts("<input type=\"submit\" name=\"command\" value=\"swap\"><br>");
	puts("<input type=\"reset\" name=\"reset\" value=\"clear form\"><br>");
	puts("</form>");
	puts("<hr><div align=\"right\"><font size=\"-1\">");
	puts("Generated by <a href=\"http://www.pc-tools.net/unix/webfilt/\">webfilt</a></font></div>");
	puts("</body>");
	puts("</html>");
}


/*
	As part of listing(), output the table line corresponding to this file
	The struct email is recalled from the server's earlier LIST
*/
void list_email(struct email* current)
{
	char linebuf[BUFSIZE], parsed[BUFSIZE];
	char* dot;
	if (fprintf(remote, "HEAD %s\n", current->filename) < 1)
		deadexit();
	if (!fgets(linebuf, sizeof(linebuf), remote))
		deadexit();
	while (*linebuf != '+')
	{
		memset(parsed, 0, BUFSIZE);
		if (strncasecmp(linebuf, "subject:", 8) == 0)
		{
			strncpy(parsed, linebuf+8, MAX_SUBJECT);
			html_sanitize(parsed, current->subject);
		}
		else if (strncasecmp(linebuf, "from:", 5) == 0)
		{
			strncpy(parsed, linebuf+5, MAX_FROM);
			html_sanitize(parsed, current->from);
		}
		if (!fgets(linebuf, sizeof(linebuf), remote))
			deadexit();
	}
	strcpy(current->time, current->filename);
	if ((dot = strchr(current->time, '.')))
		*dot = '\0';
	puts("<tr>");
	printf("<td><input type=\"checkbox\" name=\"filename\" value=\"%s\"></td>\n", current->filename);
	printf("<td>%s</td><td>%s</td><td>%s</td>\n", current->subject, current->from, current->time);
	printf("<td><input type=\"submit\" name=\"%s\" value=\"view\"></td>\n", current->filename);
	puts("</tr>");
}


void show_prompt()
{
	printf("Content-Type: text/html\n\n");
	content_set = 1;
	puts("<html>");
	puts("<head>");
	printf("<title>Login to webfilt - %s</title>\n", server_name);
	puts("</head>");
	puts("<body>");
	printf("<h2>Login to webfilt - %s</h2>\n", server_name);
	printf("<form action=\"%s\" method=\"POST\">\n", script_name);
	puts("<table bgcolor=\"#cbdced\" width=\"300\" cellspacing=\"4\" cellpadding=\"3\" border=\"0\">");
	puts("<tr><td align=\"right\">User name</td><td><input type=\"text\" name=\"user\" size=\"30\"></td></tr>");
	puts("<tr><td align=\"right\">Password</td><td><input type=\"password\" name=\"password\" size=\"30\"></td></tr>");
	puts("<tr>");
	puts("<td align=\"right\">Folder</td><td><select name=\"folder\">");
	puts("<option value=\"good\">good</option><option value=\"spam\">spam</option>");
	puts("</select></td></tr>");
	puts("<tr><td>&nbsp;</td><td><input type=\"submit\" value=\"Login\"></td></tr>");
	puts("</table></form>");
	puts("</body>");
	puts("</html>");
}


void show_file()
{
	char linebuf[BUFSIZE];
	printf("Content-Type: text/plain\n\n");
	content_set = 1;
	if (fprintf(remote, "GET %s\n", showfile) < 1)
		deadexit();

	if (!fgets(linebuf, sizeof(linebuf), remote))
		deadexit();
	if (*linebuf == '-')
		printf("View failed: %s\n", linebuf+1);
	else
	{
		while (*linebuf != '+')
		{
			printf("%s", linebuf);
			if (!fgets(linebuf, sizeof(linebuf), remote))
				deadexit();
		}
	}
}


/*	Called through re_login()	*/
void exec_command()
{
	char* token = strtok(filenames, ";");
	printf("Content-Type: text/html\n\n");
	content_set = 1;
	while (token)
	{
		char linebuf[BUFSIZE];
		/* For each filename in the list */
		printf("<br><br><i>%s %s</i><br>\n", command, token);

		if (strcmp(command, "swap") == 0)
		{
			if (fprintf(remote, "SWAP %s\n", token) < 1)
				deadexit();
		}
		else
		{
			if (fprintf(remote, "EXEC %s %s\n", command, token) < 1)
				deadexit();
		}
		
		if (!fgets(linebuf, sizeof(linebuf), remote))
			deadexit();
		if (*linebuf == '-')
			printf("<i>Failed: <b>%s</b></i><br>\n", linebuf+1);
		else
		{
			puts("<table bgcolor=\"#ddeeee\" cellpadding=\"5\">");
			puts("<tr><td><pre>");
			if (*linebuf == '+')	/* no output */
				printf("<i>(No output)</i>");
			while (*linebuf != '+')
			{
				printf("%s", linebuf);
				if (!fgets(linebuf, sizeof(linebuf), remote))
					deadexit();
			}
			puts("</pre></td></tr></table>");
		}
		token = strtok(NULL, ";");
	}
}


void show_error(const char* msg)
{
	if (!content_set)
	{
		printf("Content-Type: text/plain\n\n");
		content_set = 1;
	}
	puts(msg);
}


void html_sanitize(char* source, char* dest)
{
	int pos, len=strlen(source);
	for (pos=0; pos<len; pos++)
	{
		char mini[2] = {0, 0};
		if (source[pos] == '<')
			strcat(dest, "&lt;");
		else if (source[pos] == '>')
			strcat(dest, "&gt;");
		else
		{
			mini[0] = source[pos];
			strcat(dest, mini);
		}
	}
}
