#!/bin/sh
#
# The only parameter to this script should be the destination directory
# where the timestamped .txt file for this email message will be stored.
# This is called twice from procmail, once for each state (spam/good)
#
# :0 ci
# * ^X-SpamProbe: SPAM
# | /usr/local/bin/storelast.sh $HOME/lastmail/spam
# 
# :0 ci
# * ^X-SpamProbe: GOOD
# | /usr/local/bin/storelast.sh $HOME/lastmail/good
#

# Restricts the number of lines of the email to save
MAXLINES=200
# Make sure output files are readable by use only, nobody else
umask 0077

# Make sure we got a parameter
if [ -z $1 ]; then exit 1; fi

OUTFILE=`date +%Y-%m-%d_%H%M%S.$$`.txt

# Make sure output directory exists and is writable
if [ ! -d $1 ]; then exit 1; fi
if [ ! -w $1 ]; then exit 1; fi

# Store the mail from stdin to the appropriate file
head -n $MAXLINES > "$1/$OUTFILE"
