/************************************************
  Location of daemon's configuration file
************************************************/
#define CONF_FILE	"/etc/webfiltd.conf"


/************************************************
  Name of users' configuration file (in home dir)
************************************************/
#define USERCONF_FILE	".webfiltrc"


/************************************************
  Linux and Solaris need to include shadow.h
  BSD doesn't have shadow.h
************************************************/
/* #define USE_SHADOW_H */


/************************************************
  High-entropy random data source to use
  Linux and BSD have /dev/urandom
************************************************/
#define RAND_FILE	"/dev/urandom"


/************************************************
  Command used to LIST files for user
************************************************/
#define LIST_CMD	"/bin/ls -1"


/************************************************
  Desired maximum characters in tables
************************************************/
#define MAX_SUBJECT	40
#define MAX_FROM	40


/************************************************
  How long sessions can last, in seconds
  The CGI can't RELOGIN after this expires
************************************************/
#define SESSION_LEN	1200


/************************************************
  Port where CGI expects to find webfiltd service
************************************************/
#define WEBFILTD_PORT	136


/************************************************
  IP where CGI expects to find webfiltd service
************************************************/
#define WEBFILTD_IP	"127.0.0.1"

