#!/bin/bash
#!/bin/sh
#!/bin/ksh
#
# webfilt cgi component
# webfilt 0.91 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-tools.net/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# This CGI script interprets requests from genindex.sh/genindexentry.sh
# generated pages and sends the request to the appropriate user's public FIFO.
# This use of a named pipe ensures security isolation, and the
# code (a hidden form field) is provided to ensure that commands
# are only valid when originating from genindex.sh's page.
#
# webfilt.cgi security improvements by Kurt@pinboard.com

# You may have to modify this directory, if using another location
FIFODIR=/var/webfilt

# Read and parse the POST request
REQUEST=`cat`
USERID=`echo $REQUEST | tr '&' '\n' | sed -n 's/^user=//p' | sed -e 's/[;\`\\<>|]/ /g'`
# if these pages on your webserver are password protected and the userID
# is the same as the login userID, you might want to enable the
# following code for added security
# we only continue if the userID passed in the form and the
# authenticated userID are equal
# ----- start enabling here
#if [ "${REMOTE_USER}" != "${USERID}" ]; then
#  echo "Content-Type: text/html"
#  echo
#  echo "<HTML><HEAD><TITLE>no hackers</TITLE></HEAD>"
#  echo "<BODY BGCOLOR=\"#FFFFF0\" TEXT=\"#FF0000\">"
#  echo "<H2>Could it be you're a hacker? I don't trust you and refuse"
#  echo "to perform the action you requested.</H2></BODY></HTML>"
#  exit
#fi
# ----- stop enabling here
CODE=`echo $REQUEST | tr '&' '\n' | sed -n 's/^code=//p' | sed -e 's/[;\`\\<>|]/ /g'`
FILE=`echo $REQUEST | tr '&' '\n' | sed -n 's/^file=//p' | sed -e 's/[;\`\\<>|]/ /g' | sed "s,%2F,/,g" | sed "s,/\.\./,/,g"`
ACTION=`echo $REQUEST | tr '&' '\n' | sed -n 's/^action=//p' | sed -e 's/[;\`\\<>|]/ /g'`

echo "Content-Type: text/html"
echo
echo "<HTML><HEAD><TITLE>request: ${ACTION}</TITLE></HEAD>"
echo "<BODY BGCOLOR=\"#FFFFF0\" TEXT=\"#000000\">"
echo "<b>User:</b> $USERID<br>"
for THISFILE in ${FILE}
do
        echo "<b>File:</b> ${THISFILE}<br>"
done
echo "<b>Filter action:</b> $ACTION<br>"

if [ -z "$CODE" ]
then
	echo "<h2>Error: Received request without code (form error?)</h2>"
	exit
elif [ -z "$ACTION" ]
then
	echo "<h2>Error: Received request without action (form error?)</h2>"
	exit
elif [ -z "$FILE" ]
then
	echo "<h2>Error: Received request without filename (must select a file)</h2>"
	exit
elif [ -z "$USERID" ]
then
	echo "<h2>Error: Received request without user ID (form error?)</h2>"
	exit
fi

OUTFIFO=$FIFODIR/$USERID
INFIFO=${OUTFIFO}.IN

if [ -r $INFIFO -a -w $OUTFIFO ]
then
        for THISFILE in ${FILE}
        do
	        printf "${CODE}${ACTION}\t$ACTION\t${THISFILE}" > $OUTFIFO
                echo "<p>Posted request for ${THISFILE} to FIFO. Wait for result...</p>"
	        echo "<table bgcolor=\"#ddeeee\" cellpadding=\"5\">"
	        echo "<tr><td><pre>`cat $INFIFO`</pre></td></tr></table>"
        done
else
	echo "<h2>Error: Unable to locate public FIFOs (userfilt.sh may be dead)</h2>"
fi

# bottom of HTML
echo "</BODY></HTML>"
