#!/bin/bash
#!/bin/sh
#!/bin/ksh
#
# userfilt component
# webfilt 0.91 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-tools.net/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# The user can run this script to control filterd, the component that
# responds to webfilt queries.
#
# Using 'start' runs in foreground, 'daemon' for background.
# The 'stop' command attempts to terminate and cleanup from before.
#
#	userfilt.sh start|daemon|stop
# userfilt.sh security improvements by Kurt@pinboard.com

DIRNAME=`dirname ${0}`
FILTERD="${DIRNAME}/filterd.sh"
DEFINES="${DIRNAME}/defines.sh"
. $DEFINES

# Start of main processing

if [ -z $CMDFIFO ]
then
	echo "Error: your CMDFIFO is not defined (check defines.sh)"
	exit
fi

if [ "$1" = "start" ]
then
	echo "Starting foreground process..."
        ls ${CMDFIFO}.PID >/dev/null 2>&1
	if [ "${?}" -eq "0" ]; then
		echo "Error: FIFO seems to exist (currently running?)"
                echo "check out PID `cat ${CMDFIFO}.PID`"
		exit 1
	else
		$FILTERD
	fi
elif [ "$1" = "daemon" ]
then
	echo "Starting background process..."
        ls ${CMDFIFO}.PID >/dev/null 2>&1
	if [ "${?}" -eq "0" ]; then
		echo "Error: FIFO seems to exist (currently running?)"
                echo "check out PID `cat ${CMDFIFO}.PID`"
		exit
	else
		$FILTERD >> $LOGFILE 2>&1 &
	fi
elif [ "$1" = "stop" ]
then
	if [ -r ${CMDFIFO} ]
	then
		printf "${DIRCODE}shutdown\tshutdown\tnow" >${CMDFIFO}
	else
		echo "Unable to find FIFO. Already stopped?"
	fi
else
	echo "Usage: $0 start|daemon|stop"
fi

