#!/bin/bash
#!/bin/sh
#!/bin/ksh
#
# storelast component
# webfilt 0.91 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-tools.net/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# storelast.sh stores newly incoming mail in the applicable directories
# and adds it to the index of mails. Mail is separated by spam state.
#
# To use with spamprobe, add the following to your .procmailrc
# assuming SCORE has already been assigned the result of spamprobe
#
# :0wi
# WFSCORE=| echo $SCORE | cut -f1 -d" "
#
# :0 ci:
# | /home/username/storelast.sh "$WFSCORE"

DIRNAME=`dirname ${0}`
GENSCRIPT="${DIRNAME}/genindexentry.sh"
LISTSCRIPT="${DIRNAME}/list2html.sh"
DEFINES="${DIRNAME}/defines.sh"
. $DEFINES

# For now we provide "other" read access, so apache can read it
umask 0133
# or use the following if the directory has the group of the webserver
# user and the SGID bit set:
#umask 0137
OUTFILE=`date +%Y-%m-%d_%H%M%S.$$`.txt

# Make sure storage directories exist and lists are writable
if [ ! -d ${BASEDIR}/${SPAMDIR} ]; then exit 1; fi
if [ ! -d ${BASEDIR}/${GOODDIR} ]; then exit 1; fi
if [ ! -w ${BASEDIR}/${GOODLIST} ]; then exit 1; fi
if [ ! -w ${BASEDIR}/${SPAMLIST} ]; then exit 1; fi

# Store the mail from stdin to the appropriate file
if [ "$ISSPAM" ]
then
	head -n $MAXLINES > "${BASEDIR}/$SPAMDIR/$OUTFILE"
	$GENSCRIPT ${BASEDIR}/$SPAMDIR/${OUTFILE} >>${BASEDIR}/${SPAMLIST}
	$LISTSCRIPT 0 1
else
	head -n $MAXLINES > "${BASEDIR}/$GOODDIR/$OUTFILE"
	$GENSCRIPT ${BASEDIR}/$GOODDIR/${OUTFILE} >>${BASEDIR}/${GOODLIST}
	$LISTSCRIPT 1 0
fi

