#!/bin/bash
#!/bin/sh
#!/bin/ksh
#
# genindexentry component
# webfilt 0.91 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-tools.net/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# genindexentry.sh is used by storelast.sh and genindex.sh
# This appends an index entry of mail stored as plain text file. The
# filepath and name is given as the first parameter. The index entry is
# written to STDOUT and can directly be appended to a list file.

DIRNAME=`dirname ${0}`
DEFINES="${DIRNAME}/defines.sh"
. $DEFINES

# Make sure we got a parameter
if [ -z $1 ]
then
	exit 1
fi
# Make sure file exists and is readable
if [ ! -r $1 ]
then
	exit 1
fi

SUBJECT=`grep -i "^Subject:" ${1} | head -1 | cut -c 9-70 \
	| sed -e 's/[;\`\\]/ /g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g'`
FROM=`grep -i "^From:" ${1} | head -1 | cut -c 6-67 \
	| sed -e 's/[;\`\\]/ /g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g'`
DATETIME=`echo ${1} | sed "s,.*/\([^/.]*\).*,\1,"`
LINK=`echo ${1} | sed -e 's,.*/\([^/]*/[^/]*\),\1,'`
echo "<tr>"
echo "<td><input type=\"checkbox\" name=\"file\" value=\"${LINK}\"></td>"
echo "<td>$SUBJECT</td>"
echo "<td>$FROM</td>"
echo "<td><a href=\"${LINK}\">$DATETIME</a></td>"
echo "</tr>"
