#!/bin/bash
#!/bin/sh
#!/bin/ksh
#
# genindex component
# webfilt 0.91 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-tools.net/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# genindex.sh is used to delete old entries and regenerate the index
# it should be run regularly (daily) from cron
#
# genindex.sh efficiency improvements by Kurt@pinboard.com

DIRNAME=`dirname ${0}`
GENSCRIPT="${DIRNAME}/genindexentry.sh"
LISTSCRIPT="${DIRNAME}/list2html.sh"
DEFINES="${DIRNAME}/defines.sh"
. $DEFINES

# Make sure storage directories exist and lists are writable
if [ ! -d ${BASEDIR}/${SPAMDIR} ]; then
  mkdir -p ${BASEDIR}/${SPAMDIR}
  if [ "${?}" -ne "0" ]; then
    echo "unable to create ${BASEDIR}/${SPAMDIR}" >&2
    exit 1
  fi
fi
if [ ! -d ${BASEDIR}/${GOODDIR} ]; then
  mkdir -p ${BASEDIR}/${GOODDIR}
  if [ "${?}" -ne "0" ]; then
    echo "unable to create ${BASEDIR}/${GOODDIR}" >&2
    exit 1
  fi
fi
if [ ! -w ${BASEDIR}/${INDEXFILE} ]; then
  touch ${BASEDIR}/${INDEXFILE}
  if [ "${?}" -ne "0" ]; then
    echo "unable to create ${BASEDIR}/${INDEXFILE}" >&2
    exit 1
  fi
  chmod 644 ${BASEDIR}/${INDEXFILE}
fi
if [ ! -w ${BASEDIR}/${GOODLIST} ]; then
  touch ${BASEDIR}/${GOODLIST}
  if [ "${?}" -ne "0" ]; then
    echo "unable to create ${BASEDIR}/${GOODLIST}" >&2
    exit 1
  fi
  chmod 644 ${BASEDIR}/${GOODLIST}
fi
if [ ! -w ${BASEDIR}/${SPAMLIST} ]; then
  touch ${BASEDIR}/${SPAMLIST}
  if [ "${?}" -ne "0" ]; then
    echo "unable to create ${BASEDIR}/${SPAMLIST}" >&2
    exit 1
  fi
  chmod 644 ${BASEDIR}/${SPAMLIST}
fi

# first write the main index
cat > ${BASEDIR}/${INDEXFILE} <<EOF
<HTML>
 <HEAD><TITLE>webfilt for `whoami`</TITLE></HEAD>
 <BODY BGCOLOR="#FFFFF0">
  <H2>Hello `whoami`</H2>
  <A HREF="${GOODFILE}">mail classified as good</A><BR>
  <A HREF="${SPAMFILE}">mail classified as spam</A>
  <HR>
  last reindexed: `date`
  <DIV ALIGN="right"><FONT SIZE="-1">Generated by
       <A HREF="http://www.pc-tools.net/unix/webfilt/">webfilt 0.91</A>
       </FONT>
  </DIV>
 </BODY>
</HTML>
EOF

# delete old mail
find ${BASEDIR}/${GOODDIR} -name "*.txt" -ctime +${MAXDAYS} -print0 | xargs -0 rm -f  
find ${BASEDIR}/${SPAMDIR} -name "*.txt" -ctime +${MAXDAYS} -print0 | xargs -0 rm -f  

# recreate the actual index entries (make GOODLIST, SPAMLIST)
cat /dev/null >${BASEDIR}/${GOODLIST}
for F in `find ${BASEDIR}/${GOODDIR} -name "*.txt"`
do
  $GENSCRIPT ${F} >>${BASEDIR}/${GOODLIST}
done
cat /dev/null >${BASEDIR}/${SPAMLIST}
for F in `find ${BASEDIR}/${SPAMDIR} -name "*.txt"`
do
  $GENSCRIPT ${F} >>${BASEDIR}/${SPAMLIST}
done


# Prepare part A of template for good and spam indexes
cat >${BASEDIR}/${TEMPLATEA} <<EOF
<HTML>
 <HEAD><TITLE>@@TYPE@@ mail for `whoami`</TITLE></HEAD>
 <BODY BGCOLOR="#FFFFF0">
  <H2>mail classified as @@TYPE@@ for `whoami`</H2>
  <FORM ACTION="${CGIURL}" METHOD="post" TARGET="webfilt_results">
  <INPUT TYPE="hidden" NAME="user" VALUE="`whoami`">
  <INPUT TYPE="hidden" NAME="code" VALUE="${DIRCODE}">
  <TABLE BORDER="2" WIDTH="100%">
   <TR BGCOLOR="#EEEEEE">
    <TD>&nbsp;</TD><TH>Subject</TH><TH>From</TH><TH>File</TH>
   </TR>
EOF

# After part A of template we're going to insert mail list
# Continue with part B of template
cat >${BASEDIR}/${TEMPLATEB} <<EOF
  </TABLE>
  <BR>
  <STRONG>Filter action:</STRONG><BR>
EOF

# all the actions
for ACTION in ${ACTIONS}
do
  echo "  <INPUT TYPE=\"submit\" NAME=\"action\" VALUE=\"${ACTION}\">&nbsp;&nbsp;" >>${BASEDIR}/${TEMPLATEB}
done

# Finish off part B of template
cat >>${BASEDIR}/${TEMPLATEB} <<EOF
  <BR>
  <INPUT TYPE="reset" NAME="reset" VALUE="clear form">
  </FORM>
  <HR>
  last reindexed: `date`
  <DIV ALIGN="right"><FONT SIZE="-1">Generated by
       <A HREF="http://www.pc-tools.net/unix/webfilt/">webfilt 0.91</A>
       </FONT>
  </DIV>
 </BODY>
</HTML>
EOF

# Use templates and mail lists to generate form indexes of both good and spam
$LISTSCRIPT 1 1

