#!/bin/bash
#!/bin/sh
#!/bin/ksh
#
# filterd component
# webfilt 0.91 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-tools.net/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# This 'daemon' script processes instructions coming through
# a web writable FIFO. This named pipe ensures security isolation
# but we must still be careful about what we execute in here.
#
# filterd.sh is invoked by userfilt.sh
# filterd.sh security improvements by Kurt@pinboard.com

DIRNAME=`dirname ${0}`
DEFINES="${DIRNAME}/defines.sh"
. $DEFINES

trap shutdown 1 2 3 4 8 10 12 15
trap "" 13
# Function that does reclassification
# Syntax: reclassify state filename outpipe
reclassify()
{
	echo "Applying '$1' to file '$2'"
	CMDRESULT=`$FILTERBIN $1 $2`
	printf "(Exit code $?)\n${CMDRESULT}" >$3
}

shutdown()
{
	  rm -f ${CMDFIFO}
	  rm -f ${CMDFIFO}.IN
	  rm -f ${CMDFIFO}.PID
          exit 0
}
# Start of main

if ! [ -x $FILTERBIN ]
then
	echo "Error: $FILTERBIN doesn't exist, or is not executable"
	exit
fi

# #######################
# ###### ATTENTION ######
# #######################
# this means _anybody_ with shell access or the like, anybody who can
# get at the first FIFO, can run the commands as the user owning the
# FIFO; only the code (DIRCODE) must be known, thus you should very tightly
# protect your ~/.webfilt.code file
# 
# anybody can also read output from the second FIFO, no code needed


# FIFO should be r/w by us, and writable by the web user (nobody)
if [ -f ${CMDFIFO} ]; then
  rm -f ${CMDFIFO}
fi
mkfifo -m 622 ${CMDFIFO}
if [ "${?}" -ne "0" ]; then
  echo "can't create ${CMDFIFO}"
  exit 1
fi
# FIFO should be writable by us, and readable by web user (nobody)
mkfifo -m 244 ${CMDFIFO}.IN
if [ "${?}" -ne "0" ]; then
  echo "can't create ${CMDFIFO}.IN"
  exit 1
fi
# write PID file
touch ${CMDFIFO}.PID
# make sure only we can read it
chmod 0600 ${CMDFIFO}.PID
echo "${$}" >${CMDFIFO}.PID

echo "Now monitoring public FIFO"

while [ -r ${CMDFIFO} ]
do
	COMMAND=`cat ${CMDFIFO}`
	CODE=`echo "$COMMAND" | cut -f 1`
	ACTION=`echo "$COMMAND" | cut -f 2 | tr '\n' ' ' | sed -e 's/[;\`\\<>|]/ /g'`
	FILE=`echo "$COMMAND" | cut -f 3`
        DONE="no"
        if [ "${CODE}" = "${DIRCODE}shutdown" ];
	then
          shutdown
        fi
        for THISACTION in ${ACTIONS}
        do
          if [ "${CODE}" = "${DIRCODE}${THISACTION}" ]; then
            reclassify ${THISACTION} ${BASEDIR}/${FILE} ${CMDFIFO}.IN
            DONE="yes"
            break
          fi
        done
	if [ "${DONE}" = "no" ]; then
	  echo "Got invalid request"
        fi
done

