# To be used with webfilt
# http://www.pc-tools.net/unix/webfilt/

###############################################################
##   These values are specific to your webfilt instalation   ##
## You must change these values! Look through the WHOLE file ##
###############################################################

# This code ensures that only people who can read your generated web pages
# are able to send commands to your $FILTERBIN. Example:
# MYCODE=kfZZa892skjfyab
MYCODE=kfZZa892skjfyab
##### ----- start of section NOT TO BE CHANGED ----- #####
# this setting can be overridden by a user in his or her .webfilt.rc
# file the homedirectory
if [ -r ~/.webfilt.rc ]; then
        USERMYCODE=`grep "^MYCODE=" ~/.webfilt.rc | head -1 | sed "s/^MYCODE=//" | tr -d " ;="`
        if [ ! -z ${USERMYCODE} ]; then
                MYCODE="${USERMYCODE}"
        fi
fi
##### ----- end of section NOT TO BE CHANGED----- #####

# This is the location where logs are written to.
# use /dev/null to turn off logging
LOGFILE=~/webfilt.log
##### ----- start of section NOT TO BE CHANGED ----- #####
# this setting can be overridden by a user in his or her .webfilt.rc
# file the homedirectory
if [ -r ~/.webfilt.rc ]; then
        USERLOGFILE=`grep "^LOGFILE=" ~/.webfilt.rc | head -1 | sed "s/^LOGFILE=//" | tr -d ";|"`
        if [ ! -z ${USERLOGFILE} ]; then
                LOGFILE="${USERLOGFILE}"
        fi
fi
##### ----- end of section NOT TO BE CHANGED----- #####

# The binary you use to interact with user filter. Example:
# FILTERBIN=/usr/bin/spamprobe
FILTERBIN=/usr/bin/spamprobe

# Valid actions that your $FILTERBIN understands. Example:
# ACTIONS="spam good score summarize remove cleanup purge"
ACTIONS="spam good score"

# A decision applicable to your $FILTERBIN to determine whether text $1
# indicates spam. The result should be a non-null string if spam, and a null
# string if not spam. "$1" is the parameter to storelast.sh from ~/.procmailrc
# For example, if filter generates: "SPAM 0.9999 6fb425b3bf1052d679cfeb1"
# ISSPAM=`echo "$1" | grep ^SPAM`
ISSPAM=`echo "$1" | grep ^SPAM`

# Path where you want incoming mail copied to (according to spam state)
# An index.html file and some support files are also written here. The
# index.html file is the basis for the web interface.
# BASEDIR=~/public_html/webfilt
BASEDIR=~/public_html/webfilt
##### ----- start of section NOT TO BE CHANGED ----- #####
# this setting can be overridden by a user in his or her .webfilt.rc
# file the homedirectory
if [ -r ~/.webfilt.rc ]; then
        USERBASEDIR=`grep "^BASEDIR=" ~/.webfilt.rc | head -1 | sed "s/^BASEDIR=//" | sed "s,/../,/,g" | tr -d "<>;"`
        if [ ! -z ${USERBASEDIR} ]; then
                BASEDIR="${USERBASEDIR}"
        fi
fi
##### ----- end of section NOT TO BE CHANGED----- #####

# name of the index file in BASEDIR
INDEXFILE=index.html
##### ----- start of section NOT TO BE CHANGED ----- #####
# this setting can be overridden by a user in his or her .webfilt.rc
# file the homedirectory
if [ -r ~/.webfilt.rc ]; then
        USERINDEXFILE=`grep "^INDEXFILE=" ~/.webfilt.rc | head -1 | sed "s/^INDEXFILE=//" | tr -d "/<>;"`
        if [ ! -z ${USERINDEXFILE} ]; then
                INDEXFILE="${USERINDEXFILE}"
        fi
fi
##### ----- end of section NOT TO BE CHANGED----- #####

# (One less than) max days to keep copies of incoming mail. Example:
# MAXDAYS=4
MAXDAYS=4
##### ----- start of section NOT TO BE CHANGED ----- #####
# this setting can be overridden by a user in his or her .webfilt.rc
# file the homedirectory
if [ -r ~/.webfilt.rc ]; then
        USERMAXDAYS=`grep "^MAXDAYS=" ~/.webfilt.rc | head -1 | sed "s/^MAXDAYS=//" | sed "s,[^0-9],,g"`
        if [ ! -z ${USERMAXDAYS} ]; then
                MAXDAYS="${USERMAXDAYS}"
        fi
fi
##### ----- end of section NOT TO BE CHANGED----- #####

# Maximum lines of mail to store (keeps mail store from growing huge)
# MAXLINES=200
MAXLINES=200
##### ----- start of section NOT TO BE CHANGED ----- #####
# this setting can be overridden by a user in his or her .webfilt.rc
# file the homedirectory
if [ -r ~/.webfilt.rc ]; then
        USERMAXLINES=`grep "^MAXLINES=" ~/.webfilt.rc | head -1 | sed "s/^MAXLINES=//" | sed "s,[^0-9],,g"`
        if [ ! -z ${USERMAXLINES} ]; then
                MAXLINES="${USERMAXLINES}"
        fi
fi
##### ----- end of section NOT TO BE CHANGED----- #####

# The URL to the webfilt cgi script, written into HTML pages. Example:
# CGIURL=/cgi-bin/webfilt.cgi
CGIURL=/cgi-bin/webfilt.cgi

# Name of user's public FIFO. Example:
# CMDFIFO=/var/webfilt/`whoami`
CMDFIFO=/var/webfilt/`whoami`

# depending on what hashing utilities your OS offers, you must chose one
# or the other of the following possibilites:
# probably linux:
#DIRCODE="`echo "${BASEDIR}${MYCODE}" | md5sum | cut -d ' ' -f 1`"
# FreeBSD and the like
#DIRCODE="`echo "${BASEDIR}${MYCODE}" | md5 | cut -d ' ' -f 1`"
# solaris and most others
#DIRCODE="`echo "${BASEDIR}${MYCODE}" | cksum | cut -d ' ' -f 1`"
# any system which has openssl installed (almost all do these days)
DIRCODE="`echo "${BASEDIR}${MYCODE}" | openssl md5 | cut -d ' ' -f 1`"

# =============== DON'T CHANGE ANYTHING BELOW THIS LINE ===============
# ============== UNLESS YOU KNOW WELL WHAT YOU ARE DOING ==============
TEMPLATEA=template.a
TEMPLATEB=template.b
GOODDIR=good
SPAMDIR=spam
GOODFILE=good.html
SPAMFILE=spam.html
GOODLIST=good.incl
SPAMLIST=spam.incl
