#!/bin/bash
#
# userfilt component
# webfilt 0.90 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-utils.com/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# The user can run this script to control filterd, the component that
# responds to webfilt queries.
#
# Using 'start' runs in foreground, 'daemon' for background.
# The 'stop' command attempts to terminate and cleanup from before.
#
#	userfilt.sh start|daemon|stop

FILTERD=`echo $0 | grep -o "^.*/"`filterd.sh
DEFINES=`echo $0 | grep -o "^.*/"`defines.sh
source $DEFINES

cleanup_script()
{
	echo "Attempt to terminate running scripts, and removing FIFOs..."
        killall filterd.sh
	if [ $? == 0 ]; then echo dying > $CMDFIFO; fi
        rm -f $CMDFIFO
	rm -f $CMDFIFO.*
}

# Start of main processing

if [ -z $CMDFIFO ]
then
	echo "Error: your CMDFIFO is not defined (check defines.sh)"
	exit
fi

if [ "$1" = "start" ]
then
	echo "Starting foreground process..."
	if [ -e $CMDFIFO ]
	then
		echo "Error: FIFO exists (currently running?)"
		exit
	else
		$FILTERD $CMDFIFO
	fi
	cleanup_script
elif [ "$1" = "daemon" ]
then
	echo "Starting background process..."
	if [ -e $CMDFIFO ]
	then
		echo "Error: FIFO exists (currently running?)"
		exit
	else
		$FILTERD $CMDFIFO > /dev/null &
	fi
elif [ "$1" = "stop" ]
then
	cleanup_script
else
	echo "Usage: $0 start|daemon|stop"
fi
