#!/bin/bash
#
# storelast component
# webfilt 0.90 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-utils.com/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# storelast.sh keeps copies of last few days' mail (and automatically
# cleans up old files). Mail is separated by spam state. Script calls
# genindex.sh to make HTML indexes of mail
#
# To use with spamprobe, add the following to your .procmailrc
# assuming SCORE has already been assigned the result of spamprobe
#
# :0 c:
# | /home/username/storelast.sh "$SCORE"

GENSCRIPT=`echo $0 | grep -o "^.*/"`genindex.sh
DEFINES=`echo $0 | grep -o "^.*/"`defines.sh
source $DEFINES

# For now we provide "other" read access, so apache can read it
umask 0173
OUTFILE=`date +%Y-%m-%d_%H%M%S.$$`.txt

# Make sure storage directories exist
if [ ! -d $SPAMDIR ]; then exit 1; fi
if [ ! -d $GOODDIR ]; then exit 1; fi

# Delete last stored mail that's more than MAXDAYS old
find $SPAMDIR -name *.txt -ctime +$MAXDAYS -print0 | xargs -0r rm -f
find $GOODDIR -name *.txt -ctime +$MAXDAYS -print0 | xargs -0r rm -f

# Store the mail from stdin to the appropriate file
if [ "$ISSPAM" ]
then
	cat > "$SPAMDIR/$OUTFILE"
	$GENSCRIPT $SPAMDIR
else
	cat > "$GOODDIR/$OUTFILE"
	$GENSCRIPT $GOODDIR
fi
