#!/bin/bash
#
# genindex component
# webfilt 0.90 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-utils.com/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# genindex.sh is used by storelast.sh, but can also be run standalone.
# This generates an HTML index of mail stored as plain text files in a
# directory, given on the command line as the first parameter.

DEFINES=`echo $0 | grep -o "^.*/"`defines.sh
source $DEFINES

# Make sure we got a parameter
if [ -z $1 ]
then
	echo Error: Specify a directory
	exit 1
fi
# Make sure directory exists
if [ ! -d $1 ]
then
	echo Error: No such directory $1
	exit 1
fi
cd "$1"
DIRCODE=`echo "$1$MYCODE" | md5sum | cut -d ' ' -f 1`

# We will first write to temporary index
INDX=index.$$
echo -e "<html>\n<body bgcolor=\"#fffff0\">" > $INDX
echo -e "<form action=\"$CGIURL\" method=\"POST\">" >> $INDX
echo -e "<input type=\"hidden\" name=\"user\" value=\"`whoami`\">" >> $INDX
echo -e "<input type=\"hidden\" name=\"code\" value=\"$DIRCODE\">" >> $INDX

echo "<table width=\"100%\" border=\"2\">" >> $INDX
echo "<tr bgcolor=\"#EEEEEE\">" >> $INDX
echo -e "<th>Subject</th>\n<th>From</th>" >> $INDX
echo -e "<th>Arrival</th>\n<th>Size</th>\n</tr>" >> $INDX
for CURFILE in *.txt
do
	echo "<tr>" >> $INDX
	SUBJECT=`grep -m 1 "^Subject: " $CURFILE | cut -c 10-70 \
		| sed -e 's/[;\`\\]/ /g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g'`
	FROM=`grep -m 1 "^From: " $CURFILE | cut -c 7-67 \
		| sed -e 's/[;\`\\]/ /g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g'`
	DATETIME=`echo $CURFILE | cut -d '.' -f 1`
	FSIZE=`wc -c $CURFILE | sed -e 's/^ *//' | cut -d ' ' -f 1`
	echo -en "<td><input type=\"radio\" name=\"file\" value=\"$CURFILE\">" >> $INDX
	echo "&nbsp;$SUBJECT</td>" >> $INDX
	echo "<td>$FROM</td>" >> $INDX
	echo "<td><a href=\"$CURFILE\">$DATETIME</a></td>" >> $INDX
	echo "<td>$FSIZE</td>" >> $INDX
	echo "</tr>" >> $INDX
done

echo "</table>" >> $INDX
echo "<br><b>Filter action:</b><br>" >> $INDX
echo -e "<input type=\"submit\" name=\"action\" value=\"$ACTION1\">&nbsp;&nbsp;" >> $INDX
echo -e "<input type=\"submit\" name=\"action\" value=\"$ACTION2\">&nbsp;&nbsp;" >> $INDX
echo -e "<input type=\"submit\" name=\"action\" value=\"$ACTION3\">&nbsp;&nbsp;" >> $INDX
echo "</form><hr>" >> $INDX
echo "Generated by <a href=\"http://www.pc-utils.com/unix/webfilt/\">webfilt 0.90</a>" >> $INDX
echo -e "</body>\n</html>" >> $INDX
# Finalize
mv -f $INDX index.html
