#!/bin/bash
#
# filterd component
# webfilt 0.90 - Flexible web interface to server-side spam filters
# Copyright (C) 2003 Jem E. Berkes <jb2003@pc9.org>
# http://www.pc-utils.com/unix/webfilt/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# This 'daemon' script processes instructions coming through
# a web writable FIFO. This named pipe ensures security isolation
# but we must still be careful about what we execute in here.
#
# filterd.sh is invoked by userfilt.sh
# The first parameter to filterd.sh is the FIFO base filename

DEFINES=`echo $0 | grep -o "^.*/"`defines.sh
source $DEFINES

# Function that does reclassification
# Syntax: reclassify state filename outpipe
reclassify()
{
	echo "Applying '$1' to file '$2'"
	CMDRESULT=`$FILTERBIN $1 $2`
	echo -e "(Exit code $?)\n$CMDRESULT\n" > $3
}

# Start of main

SPAMCODE=`echo "$SPAMDIR$MYCODE" | md5sum | cut -d ' ' -f 1`
GOODCODE=`echo "$GOODDIR$MYCODE" | md5sum | cut -d ' ' -f 1`

if [ -z $1 ]
then
	echo "Error: invoked without a FIFO name"
	exit
fi

if ! [ -x $FILTERBIN ]
then
	echo "Error: $FILTERBIN doesn't exist, or is not executable"
	exit
fi

# FIFO should be r/w by us, and writable by the web user (nobody)
mkfifo -m 602 $1
# FIFO should be writable by us, and readable by web user (nobody)
mkfifo -m 204 $1.$$

echo "Now monitoring public FIFO"

while [ -r $1 ]
do
	COMMAND=`cat $1`
	CODE=`echo "$COMMAND" | cut -f 1`
	ACTION=`echo "$COMMAND" | cut -f 2`
	FILE=`echo "$COMMAND" | cut -f 3`
	if [ "$CODE" = $SPAMCODE ]
	then
		reclassify $ACTION $SPAMDIR/$FILE $1.$$
	elif [ "$CODE" = $GOODCODE ]
	then
		reclassify $ACTION $GOODDIR/$FILE $1.$$
	else
		echo "Got request with invalid code"
	fi
done

