#include <stdlib.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
printf("\nTrim 1.0 Freeware\nCopyright(C) 2000, Jem Berkes <jberkes@pc-tools.net>\nDownload updates from www.pc-tools.net\n\n");
if (argc < 4)
	{
usage:	fprintf(stderr,"Usage: trim filename x y\n\n  If filename's length exceeds x bytes, then as many as\n"
		"  y lines are removed from the start of the text file. Exit codes:\n\n"
		"0=OK, 1=can't open file, 2=can't create temp, 3=can't write to file, 255=syntax\n"
		"Information messages are sent to stdout (1). Error messages to stderr (2).\n\n");
	return 255;	// exit code 255 syntax error
	}
FILE* input = fopen(argv[1], "r");
if (input == 0)
	{
	fprintf(stderr,"Error: Could not open \"%s\" for reading\n\n", argv[1]);
	return 1;	// exit code 1
	}
int maximum = atoi(argv[2]);
if (maximum == 0)
	goto usage;
int remove = atoi(argv[3]);
if (remove == 0)
	goto usage;
// check file size
fseek(input, 0, SEEK_END);
if (ftell(input) <= maximum)
	{
	printf("\"%s\" does not exceed %u bytes: no lines removed\n\n", argv[1], maximum);
	fclose(input);
	return 0;
	}
rewind(input);
FILE *temp = tmpfile();
if (temp == 0)
	{
	fprintf(stderr,"Error: could not create temporary output file\n\n");
	fclose(input);
	return 2;	// temp error
	}
char line[8192];
int removed=0;
for (int i=0; (i<remove && fgets(line, sizeof(line), input)); i++)
	removed++;	// skip so many lines
while (fgets(line, sizeof(line), input))
	fputs(line, temp);	// write the rest to temp
fclose(input);
input = fopen(argv[1], "w");
if (input == 0)
	{
	fprintf(stderr,"Error: could not open \"%s\" for writing\n\n", argv[1]);
	fclose(temp);
	return 3;	// can't write
	}
rewind(temp);
while (fgets(line, sizeof(line), temp))
	fputs(line, input);	// copy
fclose(input);
fclose(temp);
printf("%u line(s) removed from the beginning of \"%s\"\n\n", removed, argv[1]);
return 0;
}
