#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void main (int argc, char *argv[])
{
printf("\nNoIndent 1.0 Freeware\nCopyright(C) 2000 Jem E. Berkes <jberkes@pc-tools.net>\nDownload updates from www.pc-tools.net\n\n");
if (argc==1)
	{
	printf("Usage: noindent filename\n\n");
	printf("The program will then go through the text file line by line and eliminate all\nleading indent spaces (NOT tab indents) from each line.\n\n");
	exit(0);
	}
printf("Processing \"%s\" ...\n", argv[1]);
FILE *source;
if ((source = fopen(argv[1], "r+")) == 0)
	{
	printf("Could not open file\n");
	exit(0);
	}
FILE *temp = tmpfile();
char line[1024];
while (fgets(line, sizeof(line), source))
	{
	int drop = strspn(line, " ");
	fputs(line+drop, temp);
	}
printf("Temporary file generated. Copying back over original...");
fclose(source);
source = fopen(argv[1], "w");
rewind(temp);
while (fgets(line, sizeof(line), temp))
	fputs(line, source);
fclose(source);
fclose(temp);
printf("\nDone!\n");
}
