/*
	String-style comparison function for Classless Inter-Domain Routing (CIDR)
	cidr_match 1.0
	
	Copyright (C) 2004, Jem E. Berkes <jberkes@pc-tools.net>
*/

#include <stdio.h>
#include <string.h>


/*	Returns true if ip matches cidr_spec	*/
int cidr_match(const char* ip, const char* cidr_spec)
{
	unsigned int IP[4];	/* 4 octets for IP address */
	unsigned int CIDR[4];	/* 4 octets from CIDR specification */
	int maskbits = 32;	/* to compare: between 1 and 32 bits */
	int bitno;
	
	/* Sanity checking */
	if (!ip || !cidr_spec)
		return 0;
		
	/* First parse the CIDR specification */
	if (sscanf(cidr_spec, "%u.%u.%u.%u/%d", &CIDR[0], &CIDR[1], &CIDR[2], &CIDR[3], &maskbits) != 5)
	{
		if (sscanf(cidr_spec, "%u.%u.%u.%u", &CIDR[0], &CIDR[1], &CIDR[2], &CIDR[3]) != 4)
			return 0;	/* invalid CIDR */
	}
	if ((maskbits < 1) || (maskbits > 32))
		return 0;	/* invalid CIDR */
	if ((CIDR[0] > 255) || (CIDR[1] > 255) || (CIDR[2] > 255) || (CIDR[3] > 255))
		return 0;	/* invalid CIDR */
		
	/* Parse the supplied IP address */
	if (sscanf(ip, "%u.%u.%u.%u", &IP[0], &IP[1], &IP[2], &IP[3]) != 4)
		return 0;	/* invalid IP */
	if ((IP[0] > 255) || (IP[1] > 255) || (IP[2] > 255) || (IP[3] > 255))
		return 0;	/* invalid IP */
		
	/* See if IP matches by comparing each bit, from left to right */
	for (bitno=0; bitno<maskbits; bitno++)
	{
		unsigned char mask = 0x80 >> (bitno%8);
		if ( ((unsigned char)IP[bitno/8] & mask) != ((unsigned char)CIDR[bitno/8] & mask) )
			return 0;
	}
	return 1;	/* matches */
}
